/*****************************************
*Dateiname: Header.java
*Inhalt: Klasse zum Anlegen eines Headerfensters
*****************************************/

import java.awt.*;

/*****************************************
*Klasse: Header
*Beschreibung: Legt ein Headerfenster an
*****************************************/
class Header extends CreateWindow {

      //HelpWindow help=new HelpWindow(this);
      Rectangle sourceportrect;
      HTcpSegment newest;
      boolean dat=true;
      String rectext;
      StringBuffer datastrb = new StringBuffer("");
      String datastrg = new String("");
      Label sourceport = new Label();
      Label destinationport= new Label();
      Label sequnumber= new Label();
      Label acknumber= new Label();
      Label length = new Label();
      Label unused = new Label("---");
      Label checksum= new Label();
      Label options= new Label(" O P T I O N S " );
      Label data= new Label(" D A T A ");
      Label windowsize= new Label();
      Label urgent= new Label();
      Button button3;
      Button button2;
      Panel portpanel   = new Panel();
      Panel flagpanel   = new Panel();
      Panel lupanel     = new Panel();
      Panel lufpanel    = new Panel();
      Panel lufwpanel   = new Panel();
      Panel cupanel     = new Panel();
      Panel datapanel   = new Panel();
      Panel buttonpanel = new Panel();
      Flag FIN = new Flag("F");
      Flag SYN = new Flag("S");
      Flag RST = new Flag("R");
      Flag PSH = new Flag("P");
      Flag ACK = new Flag("A");
      Flag URG = new Flag("U");
/*****************************************
* Methode: header
* Beschreibung: initialisiert den Header
* Parameter: titel, Segment
* Rckgabewert : keiner
*****************************************/
void Header(String label,HTcpSegment newest) {
       this .newest=newest;
       setTitle(label);
       //this. setBackground(Color.gray);
       //Layout
       setLayout(new GridLayout(8,1,2,2));
       addNotify();

       // Ports
       portpanel. setLayout(new GridLayout(1,2,2,2));
       sourceport. setBackground(Color.lightGray);
       sourceport. setAlignment(1);
       destinationport. setBackground(Color.lightGray);
       destinationport. setAlignment(1);
       portpanel. add(sourceport);
       portpanel. add(destinationport);
       add(portpanel);

       // Seq. numb
       add(sequnumber);
       sequnumber. setBackground(Color.lightGray);
       sequnumber. setAlignment(1);

       // Ack. numb
       add(acknumber);
       acknumber. setBackground(Color.lightGray);
       acknumber. setAlignment(1);

       // Tcpheaderlength+unused
       lupanel. setLayout(new GridLayout(1,2,2,2));
       lupanel. add(length);
       length. setBackground(Color.lightGray);
       lupanel. add(unused);
       unused. setBackground(Color.lightGray);

       // Flags
       flagpanel. setLayout(new GridLayout(1,6,2,2));
       flagpanel. add(URG);if (newest.URG==1) URG.setFlag(true);
       flagpanel. add(ACK);if (newest.ACK==1) ACK.setFlag(true);
       flagpanel. add(PSH);if (newest.PSH==1) PSH.setFlag(true);
       flagpanel. add(RST);if ((newest.RST==1)&&(newest.chsum!=0)) RST.setFlag(true);
       flagpanel. add(SYN);if (newest.SYN==1) SYN.setFlag(true);
       flagpanel. add(FIN);if (newest.FIN==1) FIN.setFlag(true);

       //Tcpheaderlength+unused+Flags
       lufpanel. setLayout(new GridLayout(1,2,2,2));
       lufpanel. add(lupanel);
       lufpanel. add(flagpanel);

       //Tcpheaderlength+unused+Flags+Wsize
       lufwpanel. setLayout(new GridLayout(1,2,2,2));
       lufwpanel. add(lufpanel);
       lufwpanel. add(windowsize);
       windowsize. setAlignment(1);
       windowsize. setBackground(Color.lightGray);
       add(lufwpanel);

       // Checksum + urgent
       cupanel. setLayout(new GridLayout(1,2,2,2));
       cupanel. add(checksum);
       cupanel. add(urgent);
       checksum. setBackground(Color.lightGray);
       checksum. setAlignment(1);
       urgent. setBackground(Color.lightGray);
       urgent. setAlignment(1);
       add(cupanel);

       // Options
       options. setBackground(Color.lightGray);
       options. setAlignment(1);
       add(options);


       // DATA
       datapanel. setLayout(new GridLayout(1,1,2,2));
       data. setBackground(Color.lightGray);
       data. setAlignment(1);
       //******Convert Data to Datastring**************
       StringBuffer rec = new StringBuffer("");
       char valuechar[] = new char[newest.data.length];  // byte fr Ausgabe vorbereiten
       for (int i=0;i<newest.data.length;i++) {
         valuechar[i]=(char) newest.data[i];
       }
       rec. append(valuechar);
       rectext=rec.toString();
       data .setText(rectext);
       add(data);

       unused. setAlignment(1);
       // resize(250,175); //187,175
       //setResizable(false);

      // buttons
      buttonpanel. setLayout(new GridLayout(1,2,2,2));
      button2= new Button();
      button2. setLabel("Help");
      button3= new Button();
      button3. setLabel("Dismiss");
      buttonpanel. add(button3);
      buttonpanel. add(button2);
      buttonpanel. setBackground(Color.yellow);
      add(buttonpanel);
      setData(dat);
    validate();
       resize(250,175); //187,175


}
void setData(boolean d){
     if (d) {
      sourceport. setFont(new Font("Arial",Font.BOLD,14));
      sourceport. setText(String.valueOf(newest.Lpnumb));
      destinationport. setFont(new Font("Arial",Font.BOLD,14));
      destinationport. setText(String.valueOf(newest.Dpnumb));
      sequnumber. setFont(new Font("Arial",Font.BOLD,14));
      sequnumber. setText(String.valueOf(newest.Seqnumb));
      acknumber. setFont(new Font("Arial",Font.BOLD,14));
      acknumber. setText(String.valueOf(newest.Acknumb));
      checksum. setFont(new Font("Arial",Font.BOLD,14));
      checksum. setText(String.valueOf(newest.chsum));
      windowsize. setFont(new Font("Arial",Font.BOLD,14));
      windowsize. setText(String.valueOf(newest.Wsize));
      urgent. setFont(new Font("Arial",Font.BOLD,14));
      urgent. setText(String.valueOf(newest.Upointer));
     }
     else {
      sourceport. setFont(new Font("Arial",Font.BOLD,14));
      sourceport. setText("Src. port");
      destinationport. setFont(new Font("Arial",Font.BOLD,14));
      destinationport. setText("Dest. port");
      sequnumber. setFont(new Font("Arial",Font.BOLD,14));
      sequnumber. setText("Seqence No. ");
      acknumber. setFont(new Font("Arial",Font.BOLD,14));
      acknumber. setText("Ack. No. ");
      checksum. setFont(new Font("Arial",Font.BOLD,14));
      checksum. setText("Cheksum");
      windowsize. setFont(new Font("Arial",Font.BOLD,14));
      windowsize. setText("Win. Size");
      urgent. setFont(new Font("Arial",Font.BOLD,14));
      urgent. setText("Urgent");
     }
}
public boolean handleEvent(Event event) {
          if (event.id == Event.ACTION_EVENT && event.target == button3) {
                    clickedButton3();
                    return true;
          }
          if (event.id == Event.ACTION_EVENT && event.target == button2) {
                    if (dat) {button2.setLabel("Data");dat=false; }
                    else {button2.setLabel("Help");dat=true;}
                    setData(dat);
                    return true;
          }
          return super.handleEvent(event);
}
/*****************************************
* Methode: clickedButton3()
* Beschreibung: Dismiss
* Parameter:  keine
* Rckgabewert : keine
*****************************************/
public void clickedButton3() {
    this .exit();
}

}



